/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class CounterSignatureCheck
extends ChainItem<XmlSAV> {
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;

    public CounterSignatureCheck(I18nProvider i18nProvider, XmlSAV result, DiagnosticData diagnosticData, SignatureWrapper signature, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.diagnosticData = diagnosticData;
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        boolean foundCountersignature = false;
        String currentSignatureId = this.signature.getId();
        List<SignatureWrapper> signatures = this.diagnosticData.getSignatures();
        for (SignatureWrapper signatureWrapper : signatures) {
            if (!signatureWrapper.isCounterSignature() || !currentSignatureId.equals(signatureWrapper.getParent().getId())) continue;
            foundCountersignature = true;
            break;
        }
        return foundCountersignature;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_IUQPCSP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_IUQPCSP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

