/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.NumericValueRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public class CertificateMinQcEuRetentionPeriodCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;
    private final NumericValueRule constraint;

    public CertificateMinQcEuRetentionPeriodCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, NumericValueRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.constraint = constraint;
    }

    @Override
    protected boolean process() {
        Integer qcEuRetentionPeriod = this.certificate.getQCEuRetentionPeriod();
        if (qcEuRetentionPeriod != null) {
            return qcEuRetentionPeriod >= this.constraint.getValue().intValue();
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_CMDCICQCERPA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_CMDCICQCERPA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

