/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceChecker;

public class ServiceConsistencyCheck
extends ChainItem<XmlValidationCertificateQualification> {
    private final TrustServiceWrapper trustService;
    private MessageTag errorMessage;

    public ServiceConsistencyCheck(I18nProvider i18nProvider, XmlValidationCertificateQualification result, TrustServiceWrapper trustService, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.trustService = trustService;
    }

    @Override
    protected boolean process() {
        if (this.trustService == null) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS0;
            return false;
        }
        if (!TrustServiceChecker.isQCStatementConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS1;
            return false;
        }
        if (!TrustServiceChecker.isQSCDConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS3;
            return false;
        }
        if (!TrustServiceChecker.isQSCDStatusAsInCertConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS3A;
            return false;
        }
        if (!TrustServiceChecker.isPostEIDASQSCDConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS3B;
            return false;
        }
        if (!TrustServiceChecker.isQualifiersListKnownConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS3C;
            return false;
        }
        if (!TrustServiceChecker.isUsageConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS4;
            return false;
        }
        if (!TrustServiceChecker.isPreEIDASStatusConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS5;
            return false;
        }
        if (!TrustServiceChecker.isPreEIDASQualifierAndAdditionalServiceInfoConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS6;
            return false;
        }
        if (!TrustServiceChecker.isQualifierAndAdditionalServiceInfoConsistent(this.trustService)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS7;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_SERV_CONS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.trustService != null && Utils.isCollectionNotEmpty(this.trustService.getServiceNames())) {
            return this.i18nProvider.getMessage(MessageTag.TRUST_SERVICE_NAME, this.trustService.getServiceNames().get(0));
        }
        return null;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

