/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.CaQcServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByCertificateTypeFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByQCFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByQSCDFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByStatusFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.GrantedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.QTSTServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByCertificateTypeFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByCountryFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByDateFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByMRAEnactedFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByMRAEquivalenceStartingDateFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByTLUrlFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.UniqueServiceFilter;
import java.util.Date;
import java.util.Set;

public final class TrustServicesFilterFactory {
    private TrustServicesFilterFactory() {
    }

    public static TrustServiceFilter createFilterByGranted() {
        return new GrantedServiceFilter();
    }

    public static TrustServiceFilter createFilterByCaQc() {
        return new CaQcServiceFilter();
    }

    public static TrustServiceFilter createFilterByQTST() {
        return new QTSTServiceFilter();
    }

    public static TrustServiceFilter createFilterByDate(Date date) {
        return new ServiceByDateFilter(date);
    }

    public static TrustServiceFilter createFilterByCountry(String countryCode) {
        return new ServiceByCountryFilter(countryCode);
    }

    public static TrustServiceFilter createFilterByCountries(Set<String> countryCodes) {
        return new ServiceByCountryFilter(countryCodes);
    }

    public static TrustServiceFilter createFilterByUrls(Set<String> urls) {
        return new ServiceByTLUrlFilter(urls);
    }

    public static TrustServiceFilter createUniqueServiceFilter(CertificateWrapper endEntityCertificate) {
        return new UniqueServiceFilter(endEntityCertificate);
    }

    public static TrustServiceFilter createFilterByCertificateType(CertificateWrapper certificate) {
        return new ServiceByCertificateTypeFilter(certificate);
    }

    public static TrustServiceFilter createConsistentServiceByStatusFilter() {
        return new ConsistentServiceByStatusFilter();
    }

    public static TrustServiceFilter createConsistentServiceByQCFilter() {
        return new ConsistentServiceByQCFilter();
    }

    public static TrustServiceFilter createConsistentServiceByCertificateTypeFilter() {
        return new ConsistentServiceByCertificateTypeFilter();
    }

    public static TrustServiceFilter createConsistentServiceByQSCDFilter() {
        return new ConsistentServiceByQSCDFilter();
    }

    public static TrustServiceFilter createMRAEnactedFilter() {
        return new ServiceByMRAEnactedFilter();
    }

    public static TrustServiceFilter createFilterByMRAEquivalenceStartingDate(Date date) {
        return new ServiceByMRAEquivalenceStartingDateFilter(date);
    }
}

