/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.LTALevelTimeStampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.TLevelTimeStampCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampDelayCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.EvidenceRecordPOE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.TimestampPOE;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.EvidenceRecordValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.LongTermAvailabilityAndIntegrityValidationMaterialCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.LongTermValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.TimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationProcessForSignaturesWithArchivalData
extends Chain<XmlValidationProcessArchivalData> {
    private final XmlValidationProcessLongTermData validationProcessLongTermData;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final List<XmlTimestamp> xmlTimestamps;
    private final List<XmlEvidenceRecord> xmlEvidenceRecords;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final POEExtraction poe;
    private Context context;
    private XmlPSV psvResult;

    public ValidationProcessForSignaturesWithArchivalData(I18nProvider i18nProvider, XmlSignature signatureAnalysis, SignatureWrapper signature, DiagnosticData diagnosticData, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentTime, POEExtraction poe) {
        super(i18nProvider, new XmlValidationProcessArchivalData());
        this.validationProcessLongTermData = signatureAnalysis.getValidationProcessLongTermData();
        this.xmlTimestamps = signatureAnalysis.getTimestamps();
        this.xmlEvidenceRecords = signatureAnalysis.getEvidenceRecords();
        this.signature = signature;
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentTime = currentTime;
        this.poe = poe;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFSWATSP;
    }

    @Override
    protected void initChain() {
        this.context = this.signature.isCounterSignature() ? Context.COUNTER_SIGNATURE : Context.SIGNATURE;
        ChainItem<XmlValidationProcessArchivalData> item = null;
        List<EvidenceRecordWrapper> evidenceRecords = this.signature.getEvidenceRecords();
        if (Utils.isCollectionNotEmpty(evidenceRecords)) {
            for (EvidenceRecordWrapper evidenceRecord : evidenceRecords) {
                XmlValidationProcessEvidenceRecord evidenceRecordValidation = this.getEvidenceRecordValidation(evidenceRecord);
                if (evidenceRecordValidation == null) continue;
                ChainItem<XmlValidationProcessArchivalData> evidenceRecordValidationConclusive = this.evidenceRecordValidationConclusive(evidenceRecord, evidenceRecordValidation);
                if (item == null) {
                    this.firstItem = evidenceRecordValidationConclusive;
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(evidenceRecordValidationConclusive);
                }
                if (!this.isValid(evidenceRecordValidation)) continue;
                this.poe.extractPOE(evidenceRecord);
            }
        }
        if (item == null) {
            this.firstItem = this.longTermValidation();
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.longTermValidation());
        }
        XmlProofOfExistence proofOfExistence = this.validationProcessLongTermData.getProofOfExistence();
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(proofOfExistence);
        if (!ValidationProcessUtils.isAllowedValidationWithLongTermData(this.validationProcessLongTermData.getConclusion())) {
            return;
        }
        if (Indication.INDETERMINATE != this.validationProcessLongTermData.getConclusion().getIndication() || SubIndication.NO_CERTIFICATE_CHAIN_FOUND_NO_POE != this.validationProcessLongTermData.getConclusion().getSubIndication()) {
            item = item.setNextItem(this.longTermAvailabilityAndIntegrityValidationMaterial());
            if (!ValidationProcessUtils.isLongTermAvailabilityAndIntegrityMaterialPresent(this.signature)) {
                return;
            }
        }
        POE bestSignatureTime = this.toPOE(proofOfExistence);
        this.poe.addSignaturePOE(this.signature, bestSignatureTime);
        List<TimestampWrapper> timestampsList = this.signature.getTimestampList();
        if (Utils.isCollectionNotEmpty(timestampsList)) {
            timestampsList.sort(Comparator.comparing(TimestampWrapper::getProductionTime).reversed());
            for (TimestampWrapper newestTimestamp : timestampsList) {
                XmlBasicBuildingBlocks bbbTsp = this.bbbs.get(newestTimestamp.getId());
                XmlValidationProcessArchivalDataTimestamp timestampValidation = this.getTimestampValidation(newestTimestamp);
                if (bbbTsp == null || timestampValidation == null) continue;
                item = item.setNextItem(this.timestampValidationConclusive(newestTimestamp, timestampValidation));
            }
        }
        item = item.setNextItem(this.tLevelTimeStamp());
        item = item.setNextItem(this.ltaLevelTimeStamp());
        bestSignatureTime = this.poe.getLowestPOE(this.signature.getId());
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(this.toXmlProofOfExistence(bestSignatureTime));
        if (this.isValid(this.validationProcessLongTermData)) {
            return;
        }
        XmlBasicBuildingBlocks sigBBB = this.bbbs.get(this.signature.getId());
        PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, this.signature, this.bbbs, this.validationProcessLongTermData.getConclusion(), this.poe, this.currentTime, this.policy, this.context);
        this.psvResult = (XmlPSV)psv.execute();
        sigBBB.setPSV(this.psvResult);
        this.enrichBBBWithPSVConclusion(sigBBB, this.psvResult);
        item = item.setNextItem(this.pastSignatureValidation(this.psvResult));
        item = item.setNextItem(this.timestampDelay(bestSignatureTime.getTime()));
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime.getTime(), this.context));
    }

    private ChainItem<XmlValidationProcessArchivalData> pastSignatureValidation(XmlPSV xmlPSV) {
        return new PastSignatureValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, xmlPSV, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationProcessArchivalData> longTermValidation() {
        return new LongTermValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.validationProcessLongTermData, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationProcessArchivalData> longTermAvailabilityAndIntegrityValidationMaterial() {
        LevelRule constraint = this.isValid(this.validationProcessLongTermData) ? this.getInfoLevelRule() : this.getFailLevelRule();
        return new LongTermAvailabilityAndIntegrityValidationMaterialCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, this.validationProcessLongTermData, constraint);
    }

    private ChainItem<XmlValidationProcessArchivalData> timestampValidationConclusive(TimestampWrapper timestampWrapper, XmlValidationProcessArchivalDataTimestamp timestampValidationResult) {
        return new TimestampValidationCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, timestampWrapper, timestampValidationResult, this.getTimestampValidationConstraintLevel());
    }

    private ChainItem<XmlValidationProcessArchivalData> evidenceRecordValidationConclusive(EvidenceRecordWrapper evidenceRecordWrapper, XmlValidationProcessEvidenceRecord erValidationResult) {
        return new EvidenceRecordValidationCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, evidenceRecordWrapper, erValidationResult, this.getEvidenceRecordValidationConstraintLevel());
    }

    private LevelRule getTimestampValidationConstraintLevel() {
        LevelRule constraint = this.policy.getTimestampValidConstraint();
        if (constraint == null) {
            constraint = this.getWarnLevelRule();
        }
        return constraint;
    }

    private LevelRule getEvidenceRecordValidationConstraintLevel() {
        LevelRule constraint = this.policy.getEvidenceRecordValidConstraint();
        if (constraint == null) {
            constraint = this.getWarnLevelRule();
        }
        return constraint;
    }

    private ChainItem<XmlValidationProcessArchivalData> tLevelTimeStamp() {
        LevelRule constraint = this.policy.getTLevelTimeStampConstraint(this.context);
        return new TLevelTimeStampCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, this.bbbs, this.xmlTimestamps, constraint);
    }

    private ChainItem<XmlValidationProcessArchivalData> ltaLevelTimeStamp() {
        LevelRule constraint = this.policy.getLTALevelTimeStampConstraint(this.context);
        return new LTALevelTimeStampCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, this.bbbs, this.xmlTimestamps, constraint);
    }

    private ChainItem<XmlValidationProcessArchivalData> timestampDelay(Date bestSignatureTime) {
        return new TimestampDelayCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, bestSignatureTime, this.policy.getTimestampDelayConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.i18nProvider, this.diagnosticData, bestSignatureTime, this.signature, context, this.bbbs, this.policy);
        XmlSAV savResult = (XmlSAV)sav.execute();
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, savResult, this.getFailLevelRule());
    }

    private void enrichBBBWithPSVConclusion(XmlBasicBuildingBlocks bbb, XmlPSV psv) {
        XmlConclusion bbbConclusion = bbb.getConclusion();
        XmlConclusion psvConclusion = psv.getConclusion();
        bbbConclusion.setIndication(psvConclusion.getIndication());
        bbbConclusion.setSubIndication(psvConclusion.getSubIndication());
        bbbConclusion.getErrors().addAll(psvConclusion.getErrors());
        bbbConclusion.getWarnings().addAll(psvConclusion.getWarnings());
        bbbConclusion.getInfos().addAll(psvConclusion.getInfos());
    }

    private XmlProofOfExistence toXmlProofOfExistence(POE poe) {
        XmlProofOfExistence xmlPoe = new XmlProofOfExistence();
        xmlPoe.setTime(poe.getTime());
        xmlPoe.setTimestampId(poe.getPOEProviderId());
        return xmlPoe;
    }

    private POE toPOE(XmlProofOfExistence xmlProofOfExistence) {
        String timestampId = xmlProofOfExistence.getTimestampId();
        if (timestampId != null) {
            for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
                if (!timestampId.equals(timestamp.getId())) continue;
                return new TimestampPOE(timestamp);
            }
            for (EvidenceRecordWrapper evidenceRecordWrapper : this.diagnosticData.getEvidenceRecords()) {
                if (!timestampId.equals(evidenceRecordWrapper.getId())) continue;
                return new EvidenceRecordPOE(evidenceRecordWrapper);
            }
        }
        return new POE(xmlProofOfExistence.getTime());
    }

    private XmlValidationProcessArchivalDataTimestamp getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!Utils.areStringsEqual(xmlTimestamp.getId(), newestTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessArchivalDataTimestamp();
        }
        return null;
    }

    private XmlValidationProcessEvidenceRecord getEvidenceRecordValidation(EvidenceRecordWrapper evidenceRecord) {
        for (XmlEvidenceRecord xmlEvidenceRecord : this.xmlEvidenceRecords) {
            if (!Utils.areStringsEqual(xmlEvidenceRecord.getId(), evidenceRecord.getId())) continue;
            return xmlEvidenceRecord.getValidationProcessEvidenceRecord();
        }
        return null;
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!(XmlBlockType.TST.equals((Object)constraint.getBlockType()) && this.policy.getTimestampValidConstraint() == null || XmlBlockType.LTA == constraint.getBlockType())) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!ValidationProcessUtils.isAllowedValidationWithLongTermData(this.validationProcessLongTermData.getConclusion()) || !ValidationProcessUtils.isLongTermAvailabilityAndIntegrityMaterialPresent(this.signature)) {
            conclusion.getWarnings().addAll(this.validationProcessLongTermData.getConclusion().getWarnings());
            conclusion.getInfos().addAll(this.validationProcessLongTermData.getConclusion().getInfos());
        }
        if (this.psvResult != null) {
            if (!this.isValid(this.psvResult) && this.psvResult.getConclusion().getSubIndication() != this.validationProcessLongTermData.getConclusion().getSubIndication()) {
                conclusion.getErrors().addAll(this.psvResult.getConclusion().getErrors());
            }
            conclusion.getWarnings().addAll(this.psvResult.getConclusion().getWarnings());
            conclusion.getInfos().addAll(this.psvResult.getConclusion().getInfos());
        }
    }
}

