/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.Collection;
import java.util.Date;

public class POENotAfterCARevocationTimeCheck<R extends RevocationWrapper>
extends ChainItem<XmlPSV> {
    private final Collection<R> revocationData;
    private final Date caRevocationTime;
    private final POEExtraction poeExtraction;

    public POENotAfterCARevocationTimeCheck(I18nProvider i18nProvider, XmlPSV result, Collection<R> revocationData, Date caRevocationTime, POEExtraction poeExtraction, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.revocationData = revocationData;
        this.caRevocationTime = caRevocationTime;
        this.poeExtraction = poeExtraction;
    }

    @Override
    protected boolean process() {
        for (RevocationWrapper revocationWrapper : this.revocationData) {
            if (!this.poeExtraction.isPOEExists(revocationWrapper.getId(), this.caRevocationTime)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_ITPRISCNARTCAC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ITPRISCNARTCAC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.REVOKED_CA_NO_POE;
    }
}

