/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpftsp.TimestampsValidationBlock;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EvidenceRecordTimestampsValidationBlock
extends TimestampsValidationBlock {
    public EvidenceRecordTimestampsValidationBlock(I18nProvider i18nProvider, EvidenceRecordWrapper evidenceRecord, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis, ValidationLevel validationLevel) {
        super(i18nProvider, evidenceRecord.getTimestampList(), diagnosticData, policy, currentTime, bbbs, tlAnalysis, validationLevel);
    }

    @Override
    protected List<TimestampWrapper> getTimestamps() {
        ArrayList<TimestampWrapper> timestampList = new ArrayList<TimestampWrapper>(this.timestamps);
        timestampList.sort(Comparator.comparing(TimestampWrapper::getProductionTime));
        return timestampList;
    }

    @Override
    protected POEExtraction getPoe(TimestampWrapper timestamp) {
        POEExtraction poe = super.getPoe(timestamp);
        TimestampWrapper nextTimestamp = this.getNextTimestamp(timestamp);
        if (nextTimestamp != null) {
            poe.extractPOE(nextTimestamp.getTimestampedObjects(), nextTimestamp.getProductionTime());
        }
        return poe;
    }

    private TimestampWrapper getNextTimestamp(TimestampWrapper currentTimestamp) {
        List<TimestampWrapper> evidenceRecordTimestamps = this.getTimestamps();
        Iterator<TimestampWrapper> it = evidenceRecordTimestamps.iterator();
        while (it.hasNext()) {
            TimestampWrapper timestampWrapper = it.next();
            if (!currentTimestamp.getId().equals(timestampWrapper.getId()) || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }
}

