/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.dto.parameters;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.TimestampDTO;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteBLevelParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureImageParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RemoteSignatureParameters
implements Serializable {
    private RemoteCertificate signingCertificate;
    private List<RemoteCertificate> certificateChain = new ArrayList<RemoteCertificate>();
    private List<RemoteDocument> detachedContents;
    private ASiCContainerType asicContainerType;
    private SignatureLevel signatureLevel;
    private RemoteBLevelParameters bLevelParams = new RemoteBLevelParameters();
    private SignaturePackaging signaturePackaging;
    private boolean embedXML;
    private boolean manifestSignature;
    private JWSSerializationType jwsSerializationType;
    private SigDMechanism sigDMechanism;
    private boolean base64UrlEncodedPayload = true;
    private boolean base64UrlEncodedEtsiUComponents = true;
    private DigestAlgorithm digestAlgorithm;
    private EncryptionAlgorithm encryptionAlgorithm;
    private DigestAlgorithm referenceDigestAlgorithm;
    private List<TimestampDTO> contentTimestamps;
    private RemoteTimestampParameters contentTimestampParameters;
    private RemoteTimestampParameters signatureTimestampParameters;
    private RemoteTimestampParameters archiveTimestampParameters;
    private boolean generateTBSWithoutCertificate = false;
    private RemoteSignatureImageParameters imageParameters;
    private String signatureIdToCounterSign;

    public RemoteCertificate getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(RemoteCertificate signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public List<RemoteCertificate> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<RemoteCertificate> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public List<RemoteDocument> getDetachedContents() {
        return this.detachedContents;
    }

    public void setDetachedContents(List<RemoteDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    public ASiCContainerType getAsicContainerType() {
        return this.asicContainerType;
    }

    public void setAsicContainerType(ASiCContainerType asicContainerType) {
        this.asicContainerType = asicContainerType;
    }

    public SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "signatureLevel must be defined!");
        this.signatureLevel = signatureLevel;
    }

    public boolean isEmbedXML() {
        return this.embedXML;
    }

    public void setEmbedXML(boolean embedXML) {
        this.embedXML = embedXML;
    }

    public boolean isManifestSignature() {
        return this.manifestSignature;
    }

    public void setManifestSignature(boolean manifestSignature) {
        this.manifestSignature = manifestSignature;
    }

    public JWSSerializationType getJwsSerializationType() {
        return this.jwsSerializationType;
    }

    public void setJwsSerializationType(JWSSerializationType jwsSerializationType) {
        this.jwsSerializationType = jwsSerializationType;
    }

    public SigDMechanism getSigDMechanism() {
        return this.sigDMechanism;
    }

    public void setSigDMechanism(SigDMechanism sigDMechanism) {
        this.sigDMechanism = sigDMechanism;
    }

    public boolean isBase64UrlEncodedPayload() {
        return this.base64UrlEncodedPayload;
    }

    public void setBase64UrlEncodedPayload(boolean base64UrlEncodedPayload) {
        this.base64UrlEncodedPayload = base64UrlEncodedPayload;
    }

    public boolean isBase64UrlEncodedEtsiUComponents() {
        return this.base64UrlEncodedEtsiUComponents;
    }

    public void setBase64UrlEncodedEtsiUComponents(boolean base64UrlEncodedEtsiUComponents) {
        this.base64UrlEncodedEtsiUComponents = base64UrlEncodedEtsiUComponents;
    }

    public DigestAlgorithm getReferenceDigestAlgorithm() {
        return this.referenceDigestAlgorithm;
    }

    public void setReferenceDigestAlgorithm(DigestAlgorithm referenceDigestAlgorithm) {
        this.referenceDigestAlgorithm = referenceDigestAlgorithm;
    }

    public RemoteBLevelParameters getBLevelParams() {
        return this.bLevelParams;
    }

    public void setBLevelParams(RemoteBLevelParameters bLevelParams) {
        this.bLevelParams = bLevelParams;
    }

    public SignaturePackaging getSignaturePackaging() {
        return this.signaturePackaging;
    }

    public void setSignaturePackaging(SignaturePackaging signaturePackaging) {
        this.signaturePackaging = signaturePackaging;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public List<TimestampDTO> getContentTimestamps() {
        return this.contentTimestamps;
    }

    public void setContentTimestamps(List<TimestampDTO> contentTimestamps) {
        this.contentTimestamps = contentTimestamps;
    }

    public RemoteTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new RemoteTimestampParameters();
        }
        return this.contentTimestampParameters;
    }

    public void setContentTimestampParameters(RemoteTimestampParameters contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters;
    }

    public RemoteTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new RemoteTimestampParameters();
        }
        return this.signatureTimestampParameters;
    }

    public void setSignatureTimestampParameters(RemoteTimestampParameters signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters;
    }

    public RemoteTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new RemoteTimestampParameters();
        }
        return this.archiveTimestampParameters;
    }

    public void setArchiveTimestampParameters(RemoteTimestampParameters archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters;
    }

    public boolean isGenerateTBSWithoutCertificate() {
        return this.generateTBSWithoutCertificate;
    }

    public void setGenerateTBSWithoutCertificate(boolean generateTBSWithoutCertificate) {
        this.generateTBSWithoutCertificate = generateTBSWithoutCertificate;
    }

    public RemoteSignatureImageParameters getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(RemoteSignatureImageParameters imageParameters) {
        this.imageParameters = imageParameters;
    }

    public String getSignatureIdToCounterSign() {
        return this.signatureIdToCounterSign;
    }

    public void setSignatureIdToCounterSign(String signatureIdToCounterSign) {
        this.signatureIdToCounterSign = signatureIdToCounterSign;
    }

    public String toString() {
        return "RemoteSignatureParameters{signingCertificate=" + this.signingCertificate + ", certificateChain=" + this.certificateChain + ", detachedContents=" + this.detachedContents + ", asicContainerType=" + (Object)((Object)this.asicContainerType) + ", signatureLevel=" + (Object)((Object)this.signatureLevel) + ", bLevelParams=" + this.bLevelParams + ", signaturePackaging=" + (Object)((Object)this.signaturePackaging) + ", embedXML=" + this.embedXML + ", manifestSignature=" + this.manifestSignature + ", jwsSerializationType=" + (Object)((Object)this.jwsSerializationType) + ", sigDMechanism=" + this.sigDMechanism + ", base64UrlEncodedPayload=" + this.base64UrlEncodedPayload + ", base64UrlEncodedEtsiUComponents=" + this.base64UrlEncodedEtsiUComponents + ", digestAlgorithm=" + this.digestAlgorithm + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", referenceDigestAlgorithm=" + this.referenceDigestAlgorithm + ", contentTimestamps=" + this.contentTimestamps + ", contentTimestampParameters=" + this.contentTimestampParameters + ", signatureTimestampParameters=" + this.signatureTimestampParameters + ", archiveTimestampParameters=" + this.archiveTimestampParameters + ", generateTBSWithoutCertificate=" + this.generateTBSWithoutCertificate + ", imageParameters=" + this.imageParameters + ", signatureIdToCounterSign='" + this.signatureIdToCounterSign + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSignatureParameters that = (RemoteSignatureParameters)o;
        return this.embedXML == that.embedXML && this.manifestSignature == that.manifestSignature && this.base64UrlEncodedPayload == that.base64UrlEncodedPayload && this.base64UrlEncodedEtsiUComponents == that.base64UrlEncodedEtsiUComponents && this.generateTBSWithoutCertificate == that.generateTBSWithoutCertificate && Objects.equals(this.signingCertificate, that.signingCertificate) && Objects.equals(this.certificateChain, that.certificateChain) && Objects.equals(this.detachedContents, that.detachedContents) && this.asicContainerType == that.asicContainerType && this.signatureLevel == that.signatureLevel && Objects.equals(this.bLevelParams, that.bLevelParams) && this.signaturePackaging == that.signaturePackaging && this.jwsSerializationType == that.jwsSerializationType && this.sigDMechanism == that.sigDMechanism && this.digestAlgorithm == that.digestAlgorithm && this.encryptionAlgorithm == that.encryptionAlgorithm && this.referenceDigestAlgorithm == that.referenceDigestAlgorithm && Objects.equals(this.contentTimestamps, that.contentTimestamps) && Objects.equals(this.contentTimestampParameters, that.contentTimestampParameters) && Objects.equals(this.signatureTimestampParameters, that.signatureTimestampParameters) && Objects.equals(this.archiveTimestampParameters, that.archiveTimestampParameters) && Objects.equals(this.imageParameters, that.imageParameters) && Objects.equals(this.signatureIdToCounterSign, that.signatureIdToCounterSign);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.signingCertificate);
        result = 31 * result + Objects.hashCode(this.certificateChain);
        result = 31 * result + Objects.hashCode(this.detachedContents);
        result = 31 * result + Objects.hashCode((Object)this.asicContainerType);
        result = 31 * result + Objects.hashCode((Object)this.signatureLevel);
        result = 31 * result + Objects.hashCode(this.bLevelParams);
        result = 31 * result + Objects.hashCode((Object)this.signaturePackaging);
        result = 31 * result + Boolean.hashCode(this.embedXML);
        result = 31 * result + Boolean.hashCode(this.manifestSignature);
        result = 31 * result + Objects.hashCode((Object)this.jwsSerializationType);
        result = 31 * result + Objects.hashCode(this.sigDMechanism);
        result = 31 * result + Boolean.hashCode(this.base64UrlEncodedPayload);
        result = 31 * result + Boolean.hashCode(this.base64UrlEncodedEtsiUComponents);
        result = 31 * result + Objects.hashCode(this.digestAlgorithm);
        result = 31 * result + Objects.hashCode(this.encryptionAlgorithm);
        result = 31 * result + Objects.hashCode(this.referenceDigestAlgorithm);
        result = 31 * result + Objects.hashCode(this.contentTimestamps);
        result = 31 * result + Objects.hashCode(this.contentTimestampParameters);
        result = 31 * result + Objects.hashCode(this.signatureTimestampParameters);
        result = 31 * result + Objects.hashCode(this.archiveTimestampParameters);
        result = 31 * result + Boolean.hashCode(this.generateTBSWithoutCertificate);
        result = 31 * result + Objects.hashCode(this.imageParameters);
        result = 31 * result + Objects.hashCode(this.signatureIdToCounterSign);
        return result;
    }
}

