/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.ValidationDataEncapsulationStrategy;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.List;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLTA
extends XAdESLevelBaselineLT {
    public XAdESLevelBaselineLTA(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        signatureRequirementsChecker.assertExtendToLTALevelPossible(signatures);
        signatureRequirementsChecker.assertSignaturesValid(signatures);
        boolean addTimestampValidationData = false;
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.xadesSignature.hasLTAProfile()) continue;
            addTimestampValidationData = true;
        }
        ValidationDataContainer validationDataContainer = null;
        if (addTimestampValidationData) {
            validationDataContainer = this.documentAnalyzer.getValidationData(signatures);
        }
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.assertExtendSignatureToLTAPossible();
            Element levelLTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            if (this.xadesSignature.hasLTAProfile() && addTimestampValidationData) {
                String indent = this.removeLastTimestampAndAnyValidationData();
                ValidationData includedValidationData = this.incorporateValidationDataForTimestamps(validationDataContainer, signature, indent);
                this.incorporateAnyValidationData(validationDataContainer, signature, indent, includedValidationData);
            }
            this.incorporateArchiveTimestamp();
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelLTUnsignedProperties);
        }
    }

    private ValidationData incorporateValidationDataForTimestamps(ValidationDataContainer validationDataContainer, AdvancedSignature signature, String indent) {
        ValidationData validationData;
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = this.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: {
                validationData = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
                this.incorporateTimestampValidationData(validationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: {
                validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                this.incorporateTimestampValidationData(validationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                validationData = new ValidationData();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", new Object[]{validationDataEncapsulationStrategy}));
            }
        }
        return validationData;
    }

    private void incorporateAnyValidationData(ValidationDataContainer validationDataContainer, AdvancedSignature signature, String indent, ValidationData validationDataToExclude) {
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = this.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureForInclusion(signature);
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignaturesForInclusion(signature));
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature));
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(validationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                ValidationData validationData = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(validationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", new Object[]{validationDataEncapsulationStrategy}));
            }
        }
    }

    private void assertExtendSignatureToLTAPossible() {
        if (SignatureLevel.XAdES_BASELINE_LTA.equals((Object)this.params.getSignatureLevel())) {
            this.assertDetachedDocumentsContainBinaries();
        }
    }
}

