/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.tsl;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.AbstractSignatureParametersBuilder;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.EnvelopedSignatureTransform;
import eu.europa.esig.dss.xades.tsl.XAdESTrustedListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractTrustedListSignatureParametersBuilder
extends AbstractSignatureParametersBuilder<XAdESSignatureParameters> {
    private static final String DEFAULT_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private static final String DEFAULT_REFERENCE_PREFIX = "ref-enveloped-signature";
    private final DSSDocument tlXmlDocument;
    private String referenceId;
    private DigestAlgorithm referenceDigestAlgorithm = DigestAlgorithm.SHA512;

    protected AbstractTrustedListSignatureParametersBuilder(CertificateToken signingCertificate, DSSDocument tlXmlDocument) {
        super(signingCertificate);
        Objects.requireNonNull(tlXmlDocument, "XML Trusted List document cannot be null!");
        this.tlXmlDocument = tlXmlDocument;
    }

    public AbstractTrustedListSignatureParametersBuilder setReferenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    public AbstractTrustedListSignatureParametersBuilder setReferenceDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.referenceDigestAlgorithm = digestAlgorithm;
        return this;
    }

    @Override
    protected XAdESSignatureParameters initParameters() {
        return new XAdESSignatureParameters();
    }

    @Override
    public XAdESSignatureParameters build() {
        XAdESSignatureParameters signatureParameters = (XAdESSignatureParameters)super.build();
        signatureParameters.setSignaturePackaging(SignaturePackaging.ENVELOPED);
        signatureParameters.setSignatureLevel(SignatureLevel.XAdES_BASELINE_B);
        signatureParameters.setEn319132(this.isEn319132());
        List<DSSReference> references = this.getReferences();
        signatureParameters.setReferences(references);
        return signatureParameters;
    }

    protected abstract boolean isEn319132();

    protected List<DSSReference> getReferences() {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        DSSReference envelopedSignatureReference = this.getEnvelopedSignatureReference();
        references.add(envelopedSignatureReference);
        return references;
    }

    protected DSSReference getEnvelopedSignatureReference() {
        DSSReference dssReference = new DSSReference();
        if (this.referenceId != null) {
            dssReference.setId(this.referenceId);
        } else {
            dssReference.setId(DEFAULT_REFERENCE_PREFIX);
        }
        dssReference.setUri("");
        dssReference.setContents(this.tlXmlDocument);
        dssReference.setDigestMethodAlgorithm(this.referenceDigestAlgorithm);
        ArrayList<DSSTransform> transforms = new ArrayList<DSSTransform>();
        EnvelopedSignatureTransform signatureTransform = new EnvelopedSignatureTransform();
        transforms.add(signatureTransform);
        CanonicalizationTransform dssTransform = new CanonicalizationTransform(DEFAULT_CANONICALIZATION);
        transforms.add(dssTransform);
        dssReference.setTransforms(transforms);
        return dssReference;
    }

    public void assertConfigurationIsValid() throws IllegalInputException {
        List<String> errors;
        try {
            errors = XAdESTrustedListUtils.validateUnsignedTrustedList(this.tlXmlDocument, (int)this.getTargetTLVersion());
        }
        catch (Exception e) {
            throw new DSSException(String.format("An error occurred on XML Trusted List validation : %s", e.getMessage()), e);
        }
        if (Utils.isCollectionNotEmpty(errors)) {
            throw new IllegalInputException(String.format("XML Trusted List failed the validation : %s", Utils.joinStrings(errors, "; ")));
        }
    }

    protected abstract Integer getTargetTLVersion();
}

