/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.validation.XAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESCRLSource
extends OfflineCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESCRLSource.class);
    private final Element signatureElement;
    private final XAdESPath xadesPaths;

    public XAdESCRLSource(Element signatureElement, XAdESPath xadesPaths) {
        Objects.requireNonNull(signatureElement, "Signature element cannot be null");
        Objects.requireNonNull(xadesPaths, "XAdESPaths cannot be null");
        this.signatureElement = signatureElement;
        this.xadesPaths = xadesPaths;
        this.collectValues(xadesPaths.getRevocationValuesPath(), RevocationOrigin.REVOCATION_VALUES);
        this.collectValues(xadesPaths.getAttributeRevocationValuesPath(), RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
        this.collectValues(xadesPaths.getTimeStampValidationDataRevocationValuesPath(), RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
        this.collectValues(xadesPaths.getAnyValidationDataRevocationValuesPath(), RevocationOrigin.ANY_VALIDATION_DATA);
        this.collectRefs(xadesPaths.getCompleteRevocationRefsPath(), RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        this.collectRefs(xadesPaths.getAttributeRevocationRefsPath(), RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    private void collectValues(String revocationValuesPath, RevocationOrigin revocationOrigin) {
        if (revocationValuesPath == null) {
            return;
        }
        NodeList revocationValuesNodeList = DomUtils.getNodeList(this.signatureElement, revocationValuesPath);
        for (int i = 0; i < revocationValuesNodeList.getLength(); ++i) {
            Element revocationValuesElement = (Element)revocationValuesNodeList.item(i);
            NodeList crlValueNodes = DomUtils.getNodeList(revocationValuesElement, this.xadesPaths.getCurrentCRLValuesChildren());
            for (int ii = 0; ii < crlValueNodes.getLength(); ++ii) {
                try {
                    Element crlValueEl = (Element)crlValueNodes.item(ii);
                    String base64EncodedCRL = crlValueEl.getTextContent();
                    CRLBinary crlBinary = CRLUtils.buildCRLBinary(Utils.fromBase64(base64EncodedCRL));
                    this.addBinary(crlBinary, revocationOrigin);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to build CRLBinary from an obtained element with origin '{}'. Reason : {}", new Object[]{revocationOrigin, e.getMessage(), e});
                }
            }
        }
    }

    private void collectRefs(String revocationRefsPath, RevocationRefOrigin revocationRefOrigin) {
        if (revocationRefsPath == null) {
            return;
        }
        NodeList revocationRefsNodeList = DomUtils.getNodeList(this.signatureElement, revocationRefsPath);
        for (int i = 0; i < revocationRefsNodeList.getLength(); ++i) {
            Element revocationRefsElement = (Element)revocationRefsNodeList.item(i);
            NodeList crlRefNodes = DomUtils.getNodeList(revocationRefsElement, this.xadesPaths.getCurrentCRLRefsChildren());
            for (int ii = 0; ii < crlRefNodes.getLength(); ++ii) {
                Element crlRefNode = (Element)crlRefNodes.item(ii);
                CRLRef crlRef = XAdESRevocationRefExtractionUtils.createCRLRef(this.xadesPaths, crlRefNode);
                if (crlRef == null) continue;
                this.addRevocationReference(crlRef, revocationRefOrigin);
            }
        }
    }
}

