/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class XAdESCertificateRefExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESCertificateRefExtractionUtils.class);

    private XAdESCertificateRefExtractionUtils() {
    }

    public static CertificateRef createCertificateRefFromV1(Element certRefElement, XAdESPath xadesPaths) {
        Digest certDigest;
        if (certRefElement != null && (certDigest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement(certRefElement, xadesPaths.getCurrentCertDigest()))) != null) {
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(certDigest);
            certRef.setCertificateIdentifier(XAdESCertificateRefExtractionUtils.getCertificateIdentifierV1(certRefElement, xadesPaths));
            return certRef;
        }
        return null;
    }

    public static CertificateRef createCertificateRefFromV2(Element certRefElement, XAdESPath xadesPaths) {
        Digest certDigest;
        if (certRefElement != null && (certDigest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement(certRefElement, xadesPaths.getCurrentCertDigest()))) != null) {
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(certDigest);
            certRef.setCertificateIdentifier(XAdESCertificateRefExtractionUtils.getCertificateIdentifierV2(certRefElement, xadesPaths));
            return certRef;
        }
        return null;
    }

    private static SignerIdentifier getCertificateIdentifierV1(Element certRefElement, XAdESPath xadesPaths) {
        Element serialNumberEl;
        X500Principal issuerName = null;
        BigInteger serialNumber = null;
        Element issuerNameEl = DomUtils.getElement(certRefElement, xadesPaths.getCurrentIssuerSerialIssuerNamePath());
        if (issuerNameEl != null) {
            issuerName = DSSUtils.getX500PrincipalOrNull(issuerNameEl.getTextContent());
        }
        if ((serialNumberEl = DomUtils.getElement(certRefElement, xadesPaths.getCurrentIssuerSerialSerialNumberPath())) != null) {
            String serialNumberText = serialNumberEl.getTextContent();
            if (Utils.isStringDigits(serialNumberText = Utils.trim(serialNumberText))) {
                serialNumber = new BigInteger(serialNumberText);
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to parse SerialNumber from 'CertIDTypeV1' element. Not a numeric! Obtained text : '{}'", (Object)serialNumberText);
            } else {
                LOG.warn("Unable to parse SerialNumber from 'CertIDTypeV1' element. Not a numeric!");
            }
        }
        if (issuerName == null || serialNumber == null) {
            LOG.warn("Unable to build a SignerIdentifier from CertIDTypeV2!");
            return null;
        }
        SignerIdentifier signerIdentifier = new SignerIdentifier();
        signerIdentifier.setIssuerName(issuerName);
        signerIdentifier.setSerialNumber(serialNumber);
        return signerIdentifier;
    }

    private static SignerIdentifier getCertificateIdentifierV2(Element certRefElement, XAdESPath xadesPaths) {
        Element issuerSerialV2Element = DomUtils.getElement(certRefElement, xadesPaths.getCurrentIssuerSerialV2Path());
        if (issuerSerialV2Element == null) {
            return null;
        }
        String textContent = issuerSerialV2Element.getTextContent();
        try {
            if (Utils.isBase64Encoded(textContent)) {
                IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(Utils.fromBase64(textContent));
                return DSSASN1Utils.toSignerIdentifier(issuerSerial);
            }
            LOG.warn("The IssuerSerialV2 value is not base64-encoded!");
        }
        catch (Exception e) {
            LOG.warn("An error occurred while parsing IssuerSerialV2 from CertIDTypeV2 element! Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

