/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.SignatureIntegrityValidator;
import java.security.PublicKey;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;

public class XAdESSignatureIntegrityValidator
extends SignatureIntegrityValidator {
    private final XMLSignature santuarioSignature;

    public XAdESSignatureIntegrityValidator(XMLSignature santuarioSignature) {
        this.santuarioSignature = santuarioSignature;
    }

    @Override
    protected boolean verify(PublicKey publicKey) throws DSSException {
        try {
            return this.santuarioSignature.checkSignatureValue(publicKey);
        }
        catch (XMLSignatureException e) {
            throw new DSSException(String.format("Unable to verify the signature : %s", e.getMessage()), e);
        }
    }
}

