/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignaturePolicyValidationResult;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.policy.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.validation.XAdESSignaturePolicy;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.io.IOException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignaturePolicyValidator.class);
    protected static final String XML_ERROR_KEY = "xmlProcessing";

    @Override
    public boolean canValidate(SignaturePolicy signaturePolicy) {
        if (signaturePolicy.getPolicyContent() != null) {
            return DomUtils.startsWithXmlPreamble(signaturePolicy.getPolicyContent());
        }
        return false;
    }

    @Override
    public SignaturePolicyValidationResult validate(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidationResult validationResult = new SignaturePolicyValidationResult();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        if (policyContent == null) {
            validationResult.addError("general", "The signature policy content is not obtained.");
            return validationResult;
        }
        validationResult.setIdentified(true);
        Digest digest = signaturePolicy.getDigest();
        if (digest == null) {
            validationResult.addError("general", "The policy digest value is not defined.");
            return validationResult;
        }
        validationResult.setDigestAlgorithmsEqual(true);
        Digest recalculatedDigest = null;
        Element transforms = null;
        if (signaturePolicy instanceof XAdESSignaturePolicy) {
            XAdESSignaturePolicy xadesSignaturePolicy = (XAdESSignaturePolicy)signaturePolicy;
            transforms = xadesSignaturePolicy.getTransforms();
        }
        if (transforms != null) {
            try {
                recalculatedDigest = this.getDigestAfterTransforms(signaturePolicy.getPolicyContent(), digest.getAlgorithm(), transforms);
            }
            catch (Exception e) {
                String errorMessage = String.format("Unable to perform transforms on an XML Policy. Reason : %s", e.getMessage());
                LOG.warn(errorMessage, e);
                validationResult.addError(XML_ERROR_KEY, errorMessage);
            }
        } else {
            recalculatedDigest = this.getComputedDigest(signaturePolicy.getPolicyContent(), digest.getAlgorithm());
        }
        validationResult.setDigest(recalculatedDigest);
        if (recalculatedDigest != null) {
            if (digest.equals(recalculatedDigest)) {
                validationResult.setDigestValid(true);
            } else {
                validationResult.addError("general", "The policy digest value (" + Utils.toBase64(digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64(recalculatedDigest.getValue()) + ").");
            }
        }
        return validationResult;
    }

    public Digest getDigestAfterTransforms(DSSDocument policyDocument, DigestAlgorithm digestAlgorithm, Element transformsElement) throws XMLSecurityException, IOException {
        if (transformsElement != null) {
            Transforms transforms = new Transforms(transformsElement, "");
            Document document = DomUtils.buildDOM(policyDocument);
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(document);
            XMLSignatureInput xmlSignatureInputOut = transforms.performTransforms(xmlSignatureInput);
            byte[] bytesToBeDigested = xmlSignatureInputOut.getBytes();
            return new Digest(digestAlgorithm, DSSUtils.digest(digestAlgorithm, bytesToBeDigested));
        }
        return this.getComputedDigest(policyDocument, digestAlgorithm);
    }
}

