/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.timestamp;

import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.validation.timestamp.TimestampMessageDigestBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampInclude;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampMessageDigestBuilder
implements TimestampMessageDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampMessageDigestBuilder.class);
    private static final String MESSAGE_IMPRINT_ERROR = "Unable to compute message-imprint for TimestampToken. Reason : %s";
    private static final String MESSAGE_IMPRINT_ERROR_WITH_ID = "Unable to compute message-imprint for TimestampToken with Id '%s'. Reason : %s";
    private final List<Reference> references;
    private final Element signature;
    private final XAdESPath xadesPaths;
    private DigestAlgorithm digestAlgorithm;
    private TimestampToken timestampToken;
    private String canonicalizationAlgorithm;
    private boolean en319132;
    private XAdESAttribute timestampAttribute;

    public XAdESTimestampMessageDigestBuilder(XAdESSignature signature, DigestAlgorithm digestAlgorithm) {
        this(signature);
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public XAdESTimestampMessageDigestBuilder(XAdESSignature signature, TimestampToken timestampToken) {
        this(signature);
        Objects.requireNonNull(timestampToken, "TimestampToken cannot be null!");
        this.timestampToken = timestampToken;
        this.digestAlgorithm = timestampToken.getDigestAlgorithm();
        this.canonicalizationAlgorithm = timestampToken.getCanonicalizationMethod();
    }

    private XAdESTimestampMessageDigestBuilder(XAdESSignature signature) {
        Objects.requireNonNull(signature, "Signature cannot be null!");
        this.signature = signature.getSignatureElement();
        this.references = signature.getReferences();
        this.xadesPaths = signature.getXAdESPaths();
    }

    public XAdESTimestampMessageDigestBuilder setCanonicalizationAlgorithm(String canonicalizationAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        return this;
    }

    public XAdESTimestampMessageDigestBuilder setEn319132(boolean en319132) {
        this.en319132 = en319132;
        return this;
    }

    public XAdESTimestampMessageDigestBuilder setTimestampAttribute(XAdESAttribute timestampAttribute) {
        this.timestampAttribute = timestampAttribute;
        if (timestampAttribute != null) {
            this.en319132 = this.isEn319132TimestampToken(timestampAttribute);
        }
        return this;
    }

    @Override
    public DSSMessageDigest getContentTimestampMessageDigest() {
        TimestampType timeStampType;
        TimestampType timestampType = timeStampType = this.timestampToken != null ? this.timestampToken.getTimeStampType() : TimestampType.ALL_DATA_OBJECTS_TIMESTAMP;
        if (this.references.isEmpty()) {
            throw new IllegalStateException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        switch (timeStampType) {
            case ALL_DATA_OBJECTS_TIMESTAMP: {
                return this.getAllDataObjectsTimestampMessageDigest();
            }
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                return this.getIndividualDataObjectsTimestampMessageDigest();
            }
        }
        throw new UnsupportedOperationException(String.format("The content timestamp of type '%s' is not supported!", new Object[]{timeStampType}));
    }

    protected DSSMessageDigest getAllDataObjectsTimestampMessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            for (Reference reference : this.references) {
                if (DSSXMLUtils.isSignedProperties(reference, this.xadesPaths)) continue;
                this.writeReferenceBytes(digestCalculator, reference, this.canonicalizationAlgorithm);
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("AllDataObjectsTimestampData message-imprint: %s", messageDigest));
            }
            return messageDigest;
        }
        catch (IOException | XMLSecurityException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to extract AllDataObjectsTimestampData. Reason : {}", (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn("Unable to extract AllDataObjectsTimestampData. Reason : {}", (Object)e.getMessage());
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    protected DSSMessageDigest getIndividualDataObjectsTimestampMessageDigest() {
        if (!this.checkTimestampTokenIncludes(this.timestampToken)) {
            throw new IllegalArgumentException("The Included referencedData attribute is either not present or set to false!");
        }
        List<TimestampInclude> includes = this.timestampToken.getTimestampIncludes();
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            for (TimestampInclude include : includes) {
                Reference reference = this.getCorrespondingReference(include, this.references);
                if (reference != null) {
                    this.writeReferenceBytes(digestCalculator, reference, this.canonicalizationAlgorithm);
                    continue;
                }
                LOG.warn("No ds:Reference found corresponding to an IndividualDataObjectsTimestamp include with URI '{}'!", (Object)include.getURI());
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("IndividualDataObjectsTimestampData message-imprint: %s", messageDigest));
            }
            return messageDigest;
        }
        catch (IOException | XMLSecurityException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to extract IndividualDataObjectsTimestampData. Reason : {}", (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn("Unable to extract IndividualDataObjectsTimestampData. Reason : {}", (Object)e.getMessage());
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    private void writeReferenceBytes(DSSMessageDigestCalculator digestCalculator, Reference reference, String canonicalizationMethod) throws IOException, XMLSecurityException {
        if (ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference))) {
            byte[] referencedBytes = reference.getReferencedBytes();
            if (DomUtils.isDOM(referencedBytes)) {
                this.writeDigestValueOnCanonicalizedBinaries(digestCalculator, referencedBytes, canonicalizationMethod);
            } else {
                digestCalculator.update(referencedBytes);
            }
        } else {
            XMLSignatureInput input = reference.getContentsAfterTransformation();
            digestCalculator.update(input.getOctetStream());
        }
    }

    private boolean checkTimestampTokenIncludes(TimestampToken timestampToken) {
        List<TimestampInclude> timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty(timestampIncludes)) {
            for (TimestampInclude timestampInclude : timestampIncludes) {
                if (timestampInclude.isReferencedData()) continue;
                return false;
            }
        }
        return true;
    }

    private Reference getCorrespondingReference(TimestampInclude timestampInclude, List<Reference> references) {
        String uri = timestampInclude.getURI();
        for (Reference reference : references) {
            if (!uri.equals(reference.getId())) continue;
            return reference;
        }
        return null;
    }

    @Override
    public DSSMessageDigest getSignatureTimestampMessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            this.writeCanonicalizedValue(digestCalculator, XMLDSigPath.SIGNATURE_VALUE_PATH, this.canonicalizationAlgorithm);
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Signature timestamp message-imprint: %s", messageDigest));
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    @Override
    public DSSMessageDigest getTimestampX1MessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            this.writeCanonicalizedValue(digestCalculator, XMLDSigPath.SIGNATURE_VALUE_PATH, this.canonicalizationAlgorithm);
            Element unsignedProperties = this.getUnsignedSignaturePropertiesCanonicalizationCopy();
            if (unsignedProperties == null) {
                throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
            }
            XAdESUnsignedSigProperties xadesUnsignedSigProperties = new XAdESUnsignedSigProperties(unsignedProperties, this.xadesPaths);
            for (XAdESAttribute xadesAttribute : xadesUnsignedSigProperties.getAttributes()) {
                if (this.timestampAttribute != null && this.timestampAttribute.equals(xadesAttribute)) break;
                if (this.en319132) {
                    if (!this.checkAttributeNameMatches(xadesAttribute, XAdES132Element.SIGNATURE_TIMESTAMP, XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                    this.writeCanonicalizedValue(digestCalculator, xadesAttribute, this.canonicalizationAlgorithm);
                    continue;
                }
                if (!this.checkAttributeNameMatches(xadesAttribute, XAdES132Element.SIGNATURE_TIMESTAMP, XAdES132Element.COMPLETE_CERTIFICATE_REFS, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                this.writeCanonicalizedValue(digestCalculator, xadesAttribute, this.canonicalizationAlgorithm);
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("X1Timestamp (SigAndRefsTimeStamp) message-imprint: %s", messageDigest));
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    @Override
    public DSSMessageDigest getTimestampX2MessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            Element unsignedProperties = this.getUnsignedSignaturePropertiesCanonicalizationCopy();
            if (unsignedProperties == null) {
                throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
            }
            XAdESUnsignedSigProperties xadesUnsignedSigProperties = new XAdESUnsignedSigProperties(unsignedProperties, this.xadesPaths);
            for (XAdESAttribute xadesAttribute : xadesUnsignedSigProperties.getAttributes()) {
                if (this.timestampAttribute != null && this.timestampAttribute.equals(xadesAttribute)) break;
                if (this.en319132) {
                    if (!this.checkAttributeNameMatches(xadesAttribute, XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                    this.writeCanonicalizedValue(digestCalculator, xadesAttribute, this.canonicalizationAlgorithm);
                    continue;
                }
                if (!this.checkAttributeNameMatches(xadesAttribute, XAdES132Element.COMPLETE_CERTIFICATE_REFS, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                this.writeCanonicalizedValue(digestCalculator, xadesAttribute, this.canonicalizationAlgorithm);
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("TimestampX2Data (RefsOnlyTimeStamp) message-imprint: %s", messageDigest));
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, e);
            } else {
                LOG.warn(errorMessage);
            }
            return null;
        }
    }

    @Override
    public DSSMessageDigest getArchiveTimestampMessageDigest() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("--->Get archive timestamp data : {}", (Object)(this.timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
            }
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            HashSet<String> referenceURIs = new HashSet<String>();
            for (Reference reference : this.references) {
                referenceURIs.add(DomUtils.getId(reference.getURI()));
                this.writeReferenceBytes(digestCalculator, reference, this.canonicalizationAlgorithm);
            }
            this.writeCanonicalizedValue(digestCalculator, XMLDSigPath.SIGNED_INFO_PATH, this.canonicalizationAlgorithm);
            this.writeCanonicalizedValue(digestCalculator, XMLDSigPath.SIGNATURE_VALUE_PATH, this.canonicalizationAlgorithm);
            this.writeCanonicalizedValue(digestCalculator, XMLDSigPath.KEY_INFO_PATH, this.canonicalizationAlgorithm);
            this.writeTimestampedUnsignedProperties(digestCalculator, this.timestampToken, this.canonicalizationAlgorithm);
            NodeList objects = this.getObjects();
            this.writeObjectBytes(digestCalculator, objects, referenceURIs, this.canonicalizationAlgorithm);
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("ArchiveTimeStamp message-imprint: %s", messageDigest));
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, e);
            } else {
                LOG.warn(errorMessage);
            }
            return null;
        }
    }

    private void writeCanonicalizedValue(DSSMessageDigestCalculator digestCalculator, String xPathString, String canonicalizationMethod) {
        Element element = DomUtils.getElement(this.signature, xPathString);
        if (element != null) {
            this.writeDigestValueOnCanonicalizedNode(digestCalculator, element, canonicalizationMethod);
        }
    }

    private void writeDigestValueOnCanonicalizedBinaries(DSSMessageDigestCalculator digestCalculator, byte[] binaries, String canonicalizationMethod) {
        try (OutputStream os = digestCalculator.getOutputStream();){
            XMLCanonicalizer.createInstance(canonicalizationMethod).canonicalize(binaries, os);
        }
        catch (IOException e) {
            throw new DSSException("Cannot build an AllDataObjectsTimestamp : An error occurred on canonicalization", e);
        }
    }

    private void writeDigestValueOnCanonicalizedNode(DSSMessageDigestCalculator digestCalculator, Node node, String canonicalizationMethod) {
        try (OutputStream os = digestCalculator.getOutputStream();){
            XMLCanonicalizer.createInstance(canonicalizationMethod).canonicalize(node, os);
        }
        catch (IOException e) {
            throw new DSSException("Cannot build an AllDataObjectsTimestamp : An error occurred on canonicalization", e);
        }
    }

    private Element getUnsignedSignaturePropertiesDom() {
        return DomUtils.getElement(this.signature, this.xadesPaths.getUnsignedSignaturePropertiesPath());
    }

    private Element getUnsignedSignaturePropertiesCanonicalizationCopy() {
        String signatureId = DSSXMLUtils.getIDIdentifier(this.signature);
        return DSSXMLUtils.ensureNamespacesDefined(this.signature.getOwnerDocument(), signatureId, this.xadesPaths.getUnsignedSignaturePropertiesPath());
    }

    private void writeTimestampedUnsignedProperties(DSSMessageDigestCalculator digestCalculator, TimestampToken timestampToken, String canonicalizationMethod) {
        XAdESUnsignedSigProperties xadesUnsignedSigProperties = this.getXAdESUnsignedSignatureProperties(timestampToken);
        for (XAdESAttribute xadesAttribute : xadesUnsignedSigProperties.getAttributes()) {
            if (this.timestampAttribute != null && this.timestampAttribute.equals(xadesAttribute)) break;
            this.writeCanonicalizedValue(digestCalculator, xadesAttribute, canonicalizationMethod);
        }
    }

    private XAdESUnsignedSigProperties getXAdESUnsignedSignatureProperties(TimestampToken timestampToken) {
        Element unsignedProperties = timestampToken == null ? this.getUnsignedSignaturePropertiesCanonicalizationCopy() : this.getUnsignedSignaturePropertiesDom();
        if (unsignedProperties == null) {
            throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
        }
        return new XAdESUnsignedSigProperties(unsignedProperties, this.xadesPaths);
    }

    private boolean isEn319132TimestampToken(XAdESAttribute timestampAttribute) {
        return this.checkAttributeNameMatches(timestampAttribute, XAdES132Element.ALL_DATA_OBJECTS_TIMESTAMP, XAdES132Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP, XAdES132Element.SIGNATURE_TIMESTAMP, XAdES141Element.REFS_ONLY_TIMESTAMP_V2, XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2, XAdES141Element.ARCHIVE_TIMESTAMP);
    }

    private boolean checkAttributeNameMatches(XAdESAttribute attribute, DSSElement ... elements) {
        if (attribute != null) {
            return Arrays.stream(elements).map(DSSElement::getTagName).anyMatch(attribute.getName()::equals);
        }
        return false;
    }

    private void writeCanonicalizedValue(DSSMessageDigestCalculator digestCalculator, XAdESAttribute attribute, String canonicalizationMethod) {
        this.writeDigestValueOnCanonicalizedNode(digestCalculator, attribute.getElement(), canonicalizationMethod);
    }

    private NodeList getObjects() {
        return DomUtils.getNodeList(this.signature, XMLDSigPath.OBJECT_PATH);
    }

    private void writeObjectBytes(DSSMessageDigestCalculator digestCalculator, NodeList objects, Set<String> referenceURIs, String canonicalizationMethod) {
        boolean xades141 = this.timestampToken == null || !ArchiveTimestampType.XAdES.equals((Object)this.timestampToken.getArchiveTimestampType());
        for (int ii = 0; ii < objects.getLength(); ++ii) {
            Node node = objects.item(ii);
            Element qualifyingProperties = DomUtils.getElement(node, this.xadesPaths.getCurrentQualifyingPropertiesPath());
            if (qualifyingProperties != null) continue;
            if (!xades141) {
                boolean contains;
                NamedNodeMap attributes = node.getAttributes();
                int length = attributes.getLength();
                String id = "";
                for (int jj = 0; jj < length; ++jj) {
                    Node item = attributes.item(jj);
                    String nodeName = item.getNodeName();
                    if (!Utils.areStringsEqualIgnoreCase("ID", nodeName)) continue;
                    id = item.getNodeValue();
                    break;
                }
                if (contains = referenceURIs.contains(id)) continue;
            }
            this.writeDigestValueOnCanonicalizedNode(digestCalculator, node, canonicalizationMethod);
        }
    }
}

