/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xml.utils;

import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.Node;

public class DOMDocument
extends CommonDocument {
    private static final long serialVersionUID = -4382025786481298319L;
    private final Node node;
    private byte[] bytes;

    public DOMDocument(Node node) {
        this(node, null);
    }

    public DOMDocument(Node node, String name) {
        Objects.requireNonNull(node, "Element cannot be null");
        this.node = node;
        this.name = name;
        this.mimeType = MimeTypeEnum.XML;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public InputStream openStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    protected byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = DomUtils.serializeNode(this.node);
        }
        return this.bytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DOMDocument that = (DOMDocument)o;
        return Arrays.equals(this.getBytes(), that.getBytes());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.getBytes());
        return result;
    }
}

