/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xml.utils;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.common.XmlDefinerUtils;
import eu.europa.esig.dss.xml.common.definition.DSSAttribute;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DSSXmlErrorListener;
import eu.europa.esig.dss.xml.utils.NamespaceContextMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class DomUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DomUtils.class);
    private static final String TRANSFORMER_METHOD_VALUE = "xml";
    private static final String HASH = "#";
    private static final String XMLNS = "xmlns";
    private static final String XNS_OPEN = "xmlns(";
    private static final String XP_OPEN = "xpointer(";
    private static final String XP_WITH_ID_OPEN = "#xpointer(id(";
    private static final String XP_ROOT = "#xpointer(/)";
    private static final String ID_ATTRIBUTE = "Id";
    private static final byte[] xmlPreamble = new byte[]{60};
    private static final byte[] xmlWithBomPreamble = new byte[]{-17, -69, -65, 60};
    private static final XPathFactory factory = XPathFactory.newInstance();
    private static final NamespaceContextMap namespacePrefixMapper = new NamespaceContextMap();

    private DomUtils() {
    }

    public static boolean registerNamespace(DSSNamespace namespace) {
        String prefix = namespace.getPrefix();
        String uri = namespace.getUri();
        if (Utils.isStringEmpty(prefix)) {
            throw new UnsupportedOperationException("The empty namespace cannot be registered!");
        }
        if (XMLNS.equals(prefix)) {
            throw new UnsupportedOperationException(String.format("The default namespace '%s' cannot be registered!", XMLNS));
        }
        return namespacePrefixMapper.registerNamespace(prefix, uri);
    }

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory() {
        return XmlDefinerUtils.getInstance().getSecureDocumentBuilderFactory();
    }

    public static TransformerFactory getSecureTransformerFactory() {
        TransformerFactory transformerFactory = XmlDefinerUtils.getInstance().getSecureTransformerFactory();
        transformerFactory.setErrorListener(new DSSXmlErrorListener());
        return transformerFactory;
    }

    public static Transformer getSecureTransformer() {
        Transformer transformer;
        TransformerFactory transformerFactory = DomUtils.getSecureTransformerFactory();
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", TRANSFORMER_METHOD_VALUE);
        }
        catch (TransformerConfigurationException e) {
            throw new DSSException(String.format("Unable to instantiate a new secure Transformer. Reason : %s", e.getMessage()), e);
        }
        transformer.setErrorListener(new DSSXmlErrorListener());
        return transformer;
    }

    public static boolean startsWithXmlPreamble(byte[] byteArray) {
        return Utils.startsWith(byteArray, xmlPreamble) || Utils.startsWith(byteArray, xmlWithBomPreamble);
    }

    public static boolean startsWithXmlPreamble(DSSDocument document) {
        try {
            return DomUtils.startsWith(document.openStream(), xmlPreamble) || DomUtils.startsWith(document.openStream(), xmlWithBomPreamble);
        }
        catch (IOException e) {
            throw new DSSException("Cannot read a sequence of bytes from the InputStream.", e);
        }
    }

    private static boolean startsWith(InputStream inputStream, byte[] preamble) throws IOException {
        try (InputStream is = inputStream;){
            if (Utils.startsWith(is, preamble)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static Document buildDOM() {
        try {
            return DomUtils.getSecureDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException(String.format("Unable to build an empty DOM : %s", e.getMessage()), e);
        }
    }

    public static Document buildDOM(String xmlString) {
        return DomUtils.buildDOM(xmlString.getBytes(StandardCharsets.UTF_8));
    }

    public static Document buildDOM(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes is required");
        return DomUtils.buildDOM(new ByteArrayInputStream(bytes));
    }

    public static Document buildDOM(InputStream inputStream) {
        Document document;
        block9: {
            InputStream is = inputStream;
            try {
                document = DomUtils.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new DSSException(String.format("Unable to parse content (XML expected) : %s", e.getMessage()), e);
                }
                catch (IOException e) {
                    throw new DSSException(String.format("An error occurred while reading InputStream : %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return document;
    }

    public static Document buildDOM(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "The document is null");
        return DomUtils.buildDOM(dssDocument.openStream());
    }

    public static boolean isDOM(byte[] bytes) {
        try {
            return DomUtils.startsWithXmlPreamble(bytes) && DomUtils.buildDOM(bytes) != null;
        }
        catch (DSSException e) {
            return false;
        }
    }

    public static boolean isDOM(DSSDocument dssDocument) {
        try {
            return DomUtils.startsWithXmlPreamble(dssDocument) && DomUtils.buildDOM(dssDocument) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setAttributeNS(Element element, DSSNamespace namespace, DSSAttribute attribute, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(namespace.getPrefix());
        sb.append(':');
        sb.append(attribute.getAttributeName());
        element.setAttributeNS(namespace.getUri(), sb.toString(), value);
    }

    public static Element addElement(Document document, Element parentDom, DSSNamespace namespace, DSSElement element) {
        Element dom = DomUtils.createElementNS(document, namespace, element);
        parentDom.appendChild(dom);
        return dom;
    }

    public static List<Node> adoptChildren(Element parentElement, Node toBeAdopted) {
        ArrayList<Node> adoptedNodes = new ArrayList<Node>();
        NodeList childNodes = toBeAdopted.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            child = parentElement.getOwnerDocument().importNode(child, true);
            Node adoptedNode = parentElement.appendChild(child);
            adoptedNodes.add(adoptedNode);
        }
        return adoptedNodes;
    }

    public static XPathExpression createXPathExpression(String xpathString) {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(namespacePrefixMapper);
        try {
            return xpath.compile(xpathString);
        }
        catch (XPathExpressionException e) {
            throw new DSSException(String.format("Unable to create an XPath expression : %s", e.getMessage()), e);
        }
    }

    public static String getValue(Node xmlNode, String xPathString) {
        try {
            XPathExpression xPathExpression = DomUtils.createXPathExpression(xPathString);
            String string = (String)xPathExpression.evaluate(xmlNode, XPathConstants.STRING);
            return Utils.trim(string);
        }
        catch (XPathExpressionException e) {
            throw new DSSException(String.format("Unable to extract value of the node. Reason : %s", e.getMessage()), e);
        }
    }

    public static NodeList getNodeList(Node xmlNode, String xPathString) {
        try {
            XPathExpression expr = DomUtils.createXPathExpression(xPathString);
            return (NodeList)expr.evaluate(xmlNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new DSSException(String.format("Unable to find a NodeList by the given xPathString '%s'. Reason : %s", xPathString, e.getMessage()), e);
        }
    }

    public static Node getNode(Node xmlNode, String xPathString) {
        NodeList list = DomUtils.getNodeList(xmlNode, xPathString);
        if (list.getLength() > 1) {
            throw new DSSException("More than one result for XPath: " + xPathString);
        }
        return list.item(0);
    }

    public static Element getElement(Node xmlNode, String xPathString) {
        return (Element)DomUtils.getNode(xmlNode, xPathString);
    }

    public static boolean isNotEmpty(Node xmlNode, String xPathString) {
        return DomUtils.getNodesAmount(xmlNode, xPathString + "/child::node()[not(self::text())]") > 0;
    }

    public static int getNodesAmount(Node xmlNode, String xPathString) {
        NodeList list = DomUtils.getNodeList(xmlNode, xPathString);
        return list.getLength();
    }

    public static Element addTextElement(Document document, Element parentDom, DSSNamespace namespace, DSSElement element, String value) {
        Element dom = DomUtils.createElementNS(document, namespace, element);
        parentDom.appendChild(dom);
        Text valueNode = document.createTextNode(value);
        dom.appendChild(valueNode);
        return dom;
    }

    public static void setTextNode(Document document, Element parentDom, String text) {
        Text textNode = document.createTextNode(text);
        parentDom.appendChild(textNode);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        try {
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlGregorianCalendar.setFractionalSecond(null);
            return xmlGregorianCalendar.normalize();
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Unable to properly convert a Date to an XMLGregorianCalendar : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static Date getDate(String text) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(text);
            return xmlGregorianCalendar.toGregorianCalendar().getTime();
        }
        catch (Exception e) {
            LOG.warn("Unable to parse '{}'", (Object)text);
            return null;
        }
    }

    public static List<String> getChildrenNames(Node xmlNode, String xPathString) {
        ArrayList<String> childrenNames = new ArrayList<String>();
        Element element = DomUtils.getElement(xmlNode, xPathString);
        if (element != null) {
            NodeList unsignedProperties = element.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                Node node = unsignedProperties.item(ii);
                childrenNames.add(node.getLocalName());
            }
        }
        return childrenNames;
    }

    public static void writeDocumentTo(Document dom, OutputStream os) {
        try {
            DOMSource xmlSource = new DOMSource(dom);
            StreamResult outputTarget = new StreamResult(os);
            Transformer transformer = DomUtils.getSecureTransformer();
            transformer.transform(xmlSource, outputTarget);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to store a DOM document to OutputStream : %s", e.getMessage()), e);
        }
    }

    public static DSSDocument createDssDocumentFromDomDocument(Document document, String name) {
        InMemoryDocument inMemoryDocument;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DomUtils.writeDocumentTo(document, baos);
            inMemoryDocument = new InMemoryDocument(baos.toByteArray(), name, (MimeType)MimeTypeEnum.XML);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to create a DSSDocument from DOM document : %s", e.getMessage()), e);
            }
        }
        baos.close();
        return inMemoryDocument;
    }

    public static String xmlToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DomUtils.serializeNode(node, result);
        return stringWriter.getBuffer().toString();
    }

    private static void serializeNode(Node node, Result result) {
        try {
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = 9 == node.getNodeType() ? (Document)node : node.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank(xmlEncoding = document.getXmlEncoding())) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new DSSException("An error occurred during a node serialization.", e);
        }
    }

    public static Map<String, String> getCurrentNamespaces() {
        return namespacePrefixMapper.getPrefixMap();
    }

    public static String getXPathByIdAttribute(String uri) {
        String id = DomUtils.getId(uri);
        return "[@*[local-name()='Id']='" + id + "' or @*[local-name()='id']='" + id + "' or @*[local-name()='ID']='" + id + "']";
    }

    public static String getId(String uri) {
        String id = uri;
        if (DomUtils.startsFromHash(uri)) {
            if (DomUtils.isXPointerQuery(uri)) {
                String xpointerId = DomUtils.getXPointerId(uri);
                if (xpointerId != null) {
                    id = xpointerId;
                }
            } else {
                id = id.substring(1);
            }
        }
        return id;
    }

    public static Element getElementById(Node node, String id) {
        try {
            return DomUtils.getElement(node, ".//*" + DomUtils.getXPathByIdAttribute(id));
        }
        catch (Exception e) {
            String errorMessage = "An exception occurred during an attempt to extract an element by its Id '{}' : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, id, e.getMessage(), e);
            } else {
                LOG.warn(errorMessage, (Object)id, (Object)e.getMessage());
            }
            return null;
        }
    }

    public static boolean startsFromHash(String uri) {
        return Utils.isStringNotBlank(uri) && uri.startsWith(HASH);
    }

    public static boolean isElementReference(String uri) {
        return DomUtils.startsFromHash(uri) && !DomUtils.isXPointerQuery(uri);
    }

    public static String toElementReference(String uri) {
        if (!DomUtils.startsFromHash(uri)) {
            uri = HASH + uri;
        }
        return uri;
    }

    public static boolean isXPointerQuery(String uriValue) {
        int ii;
        if (Utils.isStringBlank(uriValue)) {
            return false;
        }
        String uri = DomUtils.decodeUrlSilently(uriValue);
        if (DomUtils.startsFromHash(uri)) {
            uri = uri.substring(1);
        }
        String[] parts = uri.split("\\s");
        for (ii = 0; ii < parts.length - 1; ++ii) {
            if (parts[ii].endsWith(")") && parts[ii].startsWith(XNS_OPEN)) continue;
            return false;
        }
        return parts[ii].endsWith(")") && parts[ii].startsWith(XP_OPEN);
    }

    private static String decodeUrlSilently(String uriValue) {
        try {
            return URLDecoder.decode(uriValue, "UTF-8");
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            return uriValue;
        }
    }

    public static String getXPointerId(String uri) {
        if (uri.startsWith(XP_WITH_ID_OPEN) && uri.endsWith("))")) {
            String idPlusDelim = uri.substring(XP_WITH_ID_OPEN.length(), uri.length() - 2);
            int idLen = idPlusDelim.length() - 1;
            if (idPlusDelim.charAt(0) == '\"' && idPlusDelim.charAt(idLen) == '\"' || idPlusDelim.charAt(0) == '\'' && idPlusDelim.charAt(idLen) == '\'') {
                return idPlusDelim.substring(1, idLen);
            }
        }
        return null;
    }

    public static boolean isRootXPointer(String uri) {
        return XP_ROOT.equals(uri);
    }

    public static Element createElementNS(Document documentDom, DSSNamespace namespace, DSSElement element) {
        StringBuffer elementSB = new StringBuffer();
        if (Utils.isStringNotEmpty(namespace.getPrefix())) {
            elementSB.append(namespace.getPrefix());
            elementSB.append(':');
        }
        elementSB.append(element.getTagName());
        return documentDom.createElementNS(namespace.getUri(), elementSB.toString());
    }

    public static void addNamespaceAttribute(Element element, DSSNamespace namespace) {
        StringBuffer namespaceAttribute = new StringBuffer();
        namespaceAttribute.append("xmlns:");
        namespaceAttribute.append(namespace.getPrefix());
        element.setAttribute(namespaceAttribute.toString(), namespace.getUri());
    }

    public static Document excludeComments(Node node) {
        DomUtils.excludeCommentsRecursively(node);
        return DomUtils.buildDOM(DomUtils.serializeNode(node));
    }

    private static void excludeCommentsRecursively(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int ii = 0; ii < childNodes.getLength(); ++ii) {
            Node childNode = childNodes.item(ii);
            if (8 == childNode.getNodeType()) {
                node.removeChild(childNode);
                --ii;
            }
            if (!childNode.hasChildNodes()) continue;
            DomUtils.excludeCommentsRecursively(childNode);
        }
    }

    public static DSSNamespace browseRecursivelyForNamespaceWithUri(Element element, String uri) {
        String namespaceURI = element.getNamespaceURI();
        if (uri.equals(namespaceURI)) {
            String prefix = element.getPrefix();
            return new DSSNamespace(namespaceURI, prefix);
        }
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Element child;
            DSSNamespace namespace;
            Node childNode = element.getChildNodes().item(ii);
            if (childNode.getNodeType() != 1 || (namespace = DomUtils.browseRecursivelyForNamespaceWithUri(child = (Element)childNode, uri)) == null) continue;
            return namespace;
        }
        return null;
    }

    public static byte[] serializeNode(Node xmlNode) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = 9 == xmlNode.getNodeType() ? (Document)xmlNode : xmlNode.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank(xmlEncoding = document.getXmlEncoding())) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(xmlNode);
            transformer.transform(source, result);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("An error occurred during a node serialization.", e);
            }
        }
        bos.close();
        return byArray;
    }

    public static byte[] getNodeBytes(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 8: 
            case 9: {
                byte[] bytes = DomUtils.serializeNode(node);
                String str = new String(bytes);
                if (str.startsWith("<?")) {
                    str = str.substring(str.indexOf("?>") + 2);
                }
                return str.getBytes();
            }
            case 3: {
                String textContent = node.getTextContent();
                try {
                    return Utils.fromBase64(node.getTextContent());
                }
                catch (Exception e) {
                    return textContent.getBytes();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element createDeepCopy(Element element) {
        Element element2;
        if (element == null) {
            return null;
        }
        String originalId = element.getAttribute(ID_ATTRIBUTE);
        String id = null;
        Element copyElement = null;
        try {
            id = Utils.isStringBlank(originalId) ? UUID.randomUUID().toString() : originalId;
            element.setAttribute(ID_ATTRIBUTE, id);
            Element originalRoot = element.getOwnerDocument().getDocumentElement();
            Document documentCopy = DomUtils.buildDOM();
            Node copiedRoot = documentCopy.importNode(originalRoot, true);
            documentCopy.appendChild(copiedRoot);
            element2 = copyElement = DomUtils.getElementById(documentCopy, id);
        }
        catch (Throwable throwable) {
            if (Utils.isStringBlank(originalId)) {
                DomUtils.removeAttribute(element, ID_ATTRIBUTE);
                DomUtils.removeAttribute(copyElement, ID_ATTRIBUTE);
            }
            throw throwable;
        }
        if (Utils.isStringBlank(originalId)) {
            DomUtils.removeAttribute(element, ID_ATTRIBUTE);
            DomUtils.removeAttribute(copyElement, ID_ATTRIBUTE);
        }
        return element2;
    }

    private static void removeAttribute(Element element, String attributeName) {
        if (element != null && element.hasAttribute(attributeName)) {
            element.removeAttribute(attributeName);
        }
    }
}

