/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapStrings;
import org.apache.fontbox.cmap.CodespaceRange;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;

public class CMapParser {
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private final byte[] tokenParserByteBuffer = new byte[512];
    private boolean strictMode = false;

    public CMapParser() {
    }

    public CMapParser(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public CMap parsePredefined(String name) throws IOException {
        try (RandomAccessRead randomAccessRead = this.getExternalCMap(name);){
            this.strictMode = false;
            CMap cMap = this.parse(randomAccessRead);
            return cMap;
        }
    }

    public CMap parse(RandomAccessRead randomAcccessRead) throws IOException {
        CMap result = new CMap();
        Object previousToken = null;
        Object token = this.parseNextToken(randomAcccessRead);
        while (token != null) {
            if (token instanceof Operator) {
                Operator op = (Operator)token;
                if (op.op.equals("endcmap")) break;
                if (op.op.equals("usecmap") && previousToken instanceof LiteralName) {
                    this.parseUsecmap((LiteralName)previousToken, result);
                } else if (previousToken instanceof Number) {
                    if (op.op.equals("begincodespacerange")) {
                        this.parseBegincodespacerange((Number)previousToken, randomAcccessRead, result);
                    } else if (op.op.equals("beginbfchar")) {
                        this.parseBeginbfchar((Number)previousToken, randomAcccessRead, result);
                    } else if (op.op.equals("beginbfrange")) {
                        this.parseBeginbfrange((Number)previousToken, randomAcccessRead, result);
                    } else if (op.op.equals("begincidchar")) {
                        this.parseBegincidchar((Number)previousToken, randomAcccessRead, result);
                    } else if (op.op.equals("begincidrange") && previousToken instanceof Integer) {
                        this.parseBegincidrange((Integer)previousToken, randomAcccessRead, result);
                    }
                }
            } else if (token instanceof LiteralName) {
                this.parseLiteralName((LiteralName)token, randomAcccessRead, result);
            }
            previousToken = token;
            token = this.parseNextToken(randomAcccessRead);
        }
        return result;
    }

    private void parseUsecmap(LiteralName useCmapName, CMap result) throws IOException {
        try (RandomAccessRead randomAccessRead = this.getExternalCMap(useCmapName.name);){
            CMap useCMap = this.parse(randomAccessRead);
            result.useCmap(useCMap);
        }
    }

    private void parseLiteralName(LiteralName literal, RandomAccessRead randomAcccessRead, CMap result) throws IOException {
        switch (literal.name) {
            case "WMode": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (!(next instanceof Integer)) break;
                result.setWMode((Integer)next);
                break;
            }
            case "CMapName": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (!(next instanceof LiteralName)) break;
                result.setName(((LiteralName)next).name);
                break;
            }
            case "CMapVersion": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (next instanceof Number) {
                    result.setVersion(next.toString());
                    break;
                }
                if (!(next instanceof String)) break;
                result.setVersion((String)next);
                break;
            }
            case "CMapType": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (!(next instanceof Integer)) break;
                result.setType((Integer)next);
                break;
            }
            case "Registry": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (!(next instanceof String)) break;
                result.setRegistry((String)next);
                break;
            }
            case "Ordering": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (!(next instanceof String)) break;
                result.setOrdering((String)next);
                break;
            }
            case "Supplement": {
                Object next = this.parseNextToken(randomAcccessRead);
                if (!(next instanceof Integer)) break;
                result.setSupplement((Integer)next);
                break;
            }
        }
    }

    private void checkExpectedOperator(Operator operator, String expectedOperatorName, String rangeName) throws IOException {
        if (!operator.op.equals(expectedOperatorName)) {
            throw new IOException("Error : ~" + rangeName + " contains an unexpected operator : " + operator.op);
        }
    }

    private void parseBegincodespacerange(Number cosCount, RandomAccessRead randomAcccessRead, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            Object nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof Operator) {
                this.checkExpectedOperator((Operator)nextToken, "endcodespacerange", "codespacerange");
                break;
            }
            if (!(nextToken instanceof byte[])) {
                throw new IOException("start range missing");
            }
            byte[] startRange = (byte[])nextToken;
            byte[] endRange = this.parseByteArray(randomAcccessRead);
            try {
                result.addCodespaceRange(new CodespaceRange(startRange, endRange));
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
        }
    }

    private void parseBeginbfchar(Number cosCount, RandomAccessRead randomAcccessRead, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            Object nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof Operator) {
                this.checkExpectedOperator((Operator)nextToken, "endbfchar", "bfchar");
                break;
            }
            if (!(nextToken instanceof byte[])) {
                throw new IOException("input code missing");
            }
            byte[] inputCode = (byte[])nextToken;
            nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof byte[]) {
                byte[] bytes = (byte[])nextToken;
                String value = CMapParser.createStringFromBytes(bytes);
                result.addCharMapping(inputCode, value);
                continue;
            }
            if (nextToken instanceof LiteralName) {
                result.addCharMapping(inputCode, ((LiteralName)nextToken).name);
                continue;
            }
            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + nextToken);
        }
    }

    private void parseBegincidrange(int numberOfLines, RandomAccessRead randomAcccessRead, CMap result) throws IOException {
        for (int n = 0; n < numberOfLines; ++n) {
            Object nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof Operator) {
                this.checkExpectedOperator((Operator)nextToken, "endcidrange", "cidrange");
                break;
            }
            if (!(nextToken instanceof byte[])) {
                throw new IOException("start code missing");
            }
            byte[] startCode = (byte[])nextToken;
            byte[] endCode = this.parseByteArray(randomAcccessRead);
            int mappedCode = this.parseInteger(randomAcccessRead);
            if (startCode.length == endCode.length) {
                if (Arrays.equals(startCode, endCode)) {
                    result.addCIDMapping(startCode, mappedCode);
                    continue;
                }
                result.addCIDRange(startCode, endCode, mappedCode);
                continue;
            }
            throw new IOException("Error : ~cidrange values must not have different byte lengths");
        }
    }

    private void parseBegincidchar(Number cosCount, RandomAccessRead randomAcccessRead, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            Object nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof Operator) {
                this.checkExpectedOperator((Operator)nextToken, "endcidchar", "cidchar");
                break;
            }
            if (!(nextToken instanceof byte[])) {
                throw new IOException("input code missing");
            }
            byte[] inputCode = (byte[])nextToken;
            int mappedCID = this.parseInteger(randomAcccessRead);
            result.addCIDMapping(inputCode, mappedCID);
        }
    }

    private void parseBeginbfrange(Number cosCount, RandomAccessRead randomAcccessRead, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            byte[] tokenBytes;
            Object nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof Operator) {
                this.checkExpectedOperator((Operator)nextToken, "endbfrange", "bfrange");
                break;
            }
            if (!(nextToken instanceof byte[])) {
                throw new IOException("start code missing");
            }
            byte[] startCode = (byte[])nextToken;
            nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof Operator) {
                this.checkExpectedOperator((Operator)nextToken, "endbfrange", "bfrange");
                break;
            }
            if (!(nextToken instanceof byte[])) {
                throw new IOException("end code missing");
            }
            byte[] endCode = (byte[])nextToken;
            int start = CMap.toInt(startCode);
            int end = CMap.toInt(endCode);
            if (end < start) break;
            nextToken = this.parseNextToken(randomAcccessRead);
            if (nextToken instanceof List) {
                List array = (List)nextToken;
                if (array.isEmpty() || array.size() < end - start) continue;
                this.addMappingFrombfrange(result, startCode, array);
                continue;
            }
            if (!(nextToken instanceof byte[]) || (tokenBytes = (byte[])nextToken).length <= 0) continue;
            if (tokenBytes.length == 2 && start == 0 && end == 65535 && tokenBytes[0] == 0 && tokenBytes[1] == 0) {
                for (int i = 0; i < 256; ++i) {
                    startCode[0] = (byte)i;
                    startCode[1] = 0;
                    tokenBytes[0] = (byte)i;
                    tokenBytes[1] = 0;
                    this.addMappingFrombfrange(result, startCode, 256, tokenBytes);
                }
                continue;
            }
            this.addMappingFrombfrange(result, startCode, end - start + 1, tokenBytes);
        }
    }

    private void addMappingFrombfrange(CMap cmap, byte[] startCode, List<byte[]> tokenBytesList) {
        for (byte[] tokenBytes : tokenBytesList) {
            String value = CMapParser.createStringFromBytes(tokenBytes);
            cmap.addCharMapping(startCode, value);
            CMapParser.increment(startCode, startCode.length - 1, false);
        }
    }

    private void addMappingFrombfrange(CMap cmap, byte[] startCode, int values2, byte[] tokenBytes) {
        for (int i = 0; i < values2; ++i) {
            String value = CMapParser.createStringFromBytes(tokenBytes);
            cmap.addCharMapping(startCode, value);
            if (!CMapParser.increment(tokenBytes, tokenBytes.length - 1, this.strictMode)) break;
            CMapParser.increment(startCode, startCode.length - 1, false);
        }
    }

    private RandomAccessRead getExternalCMap(String name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Error: Could not find referenced cmap stream " + name);
        }
        return new RandomAccessReadBuffer(is);
    }

    private Object parseNextToken(RandomAccessRead randomAcccessRead) throws IOException {
        int nextByte = randomAcccessRead.read();
        while (nextByte == 9 || nextByte == 32 || nextByte == 13 || nextByte == 10) {
            nextByte = randomAcccessRead.read();
        }
        switch (nextByte) {
            case 37: {
                return this.readLine(randomAcccessRead, nextByte);
            }
            case 40: {
                return this.readString(randomAcccessRead);
            }
            case 62: {
                if (randomAcccessRead.read() == 62) {
                    return MARK_END_OF_DICTIONARY;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                return MARK_END_OF_ARRAY;
            }
            case 91: {
                return this.readArray(randomAcccessRead);
            }
            case 60: {
                return this.readDictionary(randomAcccessRead);
            }
            case 47: {
                return this.readLiteralName(randomAcccessRead);
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readNumber(randomAcccessRead, nextByte);
            }
            default: {
                return this.readOperator(randomAcccessRead, nextByte);
            }
        }
        return null;
    }

    private Integer parseInteger(RandomAccessRead randomAcccessRead) throws IOException {
        Object nextToken = this.parseNextToken(randomAcccessRead);
        if (nextToken == null) {
            throw new IOException("expected integer value is missing");
        }
        if (nextToken instanceof Integer) {
            return (Integer)nextToken;
        }
        throw new IOException("invalid type for next token");
    }

    private byte[] parseByteArray(RandomAccessRead randomAcccessRead) throws IOException {
        Object nextToken = this.parseNextToken(randomAcccessRead);
        if (nextToken == null) {
            throw new IOException("expected byte[] value is missing");
        }
        if (nextToken instanceof byte[]) {
            return (byte[])nextToken;
        }
        throw new IOException("invalid type for next token");
    }

    private List<Object> readArray(RandomAccessRead randomAcccessRead) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        Object nextToken = this.parseNextToken(randomAcccessRead);
        while (nextToken != null && !MARK_END_OF_ARRAY.equals(nextToken)) {
            list.add(nextToken);
            nextToken = this.parseNextToken(randomAcccessRead);
        }
        return list;
    }

    private String readString(RandomAccessRead randomAcccessRead) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int stringByte = randomAcccessRead.read();
        while (stringByte != -1 && stringByte != 41) {
            buffer.append((char)stringByte);
            stringByte = randomAcccessRead.read();
        }
        return buffer.toString();
    }

    private String readLine(RandomAccessRead randomAcccessRead, int firstByte) throws IOException {
        int nextByte = firstByte;
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)nextByte);
        this.readUntilEndOfLine(randomAcccessRead, buffer);
        return buffer.toString();
    }

    private LiteralName readLiteralName(RandomAccessRead randomAcccessRead) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int stringByte = randomAcccessRead.read();
        while (!CMapParser.isWhitespaceOrEOF(stringByte) && !CMapParser.isDelimiter(stringByte)) {
            buffer.append((char)stringByte);
            stringByte = randomAcccessRead.read();
        }
        if (CMapParser.isDelimiter(stringByte)) {
            randomAcccessRead.rewind(1);
        }
        return new LiteralName(buffer.toString());
    }

    private Operator readOperator(RandomAccessRead randomAcccessRead, int firstByte) throws IOException {
        int nextByte = firstByte;
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)nextByte);
        nextByte = randomAcccessRead.read();
        while (!(CMapParser.isWhitespaceOrEOF(nextByte) || CMapParser.isDelimiter(nextByte) || Character.isDigit(nextByte))) {
            buffer.append((char)nextByte);
            nextByte = randomAcccessRead.read();
        }
        if (CMapParser.isDelimiter(nextByte) || Character.isDigit(nextByte)) {
            randomAcccessRead.rewind(1);
        }
        return new Operator(buffer.toString());
    }

    private Number readNumber(RandomAccessRead randomAcccessRead, int firstByte) throws IOException {
        int nextByte = firstByte;
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)nextByte);
        nextByte = randomAcccessRead.read();
        while (!CMapParser.isWhitespaceOrEOF(nextByte) && (Character.isDigit((char)nextByte) || nextByte == 46)) {
            buffer.append((char)nextByte);
            nextByte = randomAcccessRead.read();
        }
        if (nextByte != -1) {
            randomAcccessRead.rewind(1);
        }
        String value = buffer.toString();
        try {
            if (value.indexOf(46) >= 0) {
                return Double.valueOf(value);
            }
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Invalid number '" + value + "'", ex);
        }
    }

    private Object readDictionary(RandomAccessRead randomAcccessRead) throws IOException {
        int theNextByte = randomAcccessRead.read();
        if (theNextByte == 60) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object key = this.parseNextToken(randomAcccessRead);
            while (key instanceof LiteralName && !MARK_END_OF_DICTIONARY.equals(((LiteralName)key).name)) {
                Object value = this.parseNextToken(randomAcccessRead);
                result.put(((LiteralName)key).name, value);
                key = this.parseNextToken(randomAcccessRead);
            }
            return result;
        }
        int multiplyer = 16;
        int bufferIndex = -1;
        while (theNextByte != -1 && theNextByte != 62) {
            if (CMapParser.isWhitespaceOrEOF(theNextByte)) {
                theNextByte = randomAcccessRead.read();
                continue;
            }
            int intValue = 0;
            if (theNextByte >= 48 && theNextByte <= 57) {
                intValue = theNextByte - 48;
            } else if (theNextByte >= 65 && theNextByte <= 70) {
                intValue = 10 + theNextByte - 65;
            } else if (theNextByte >= 97 && theNextByte <= 102) {
                intValue = 10 + theNextByte - 97;
            } else {
                throw new IOException("Error: expected hex character and not " + (char)theNextByte + ":" + theNextByte);
            }
            intValue *= multiplyer;
            if (multiplyer == 16) {
                if (++bufferIndex >= this.tokenParserByteBuffer.length) {
                    throw new IOException("cmap token ist larger than buffer size " + this.tokenParserByteBuffer.length);
                }
                this.tokenParserByteBuffer[bufferIndex] = 0;
                multiplyer = 1;
            } else {
                multiplyer = 16;
            }
            int n = bufferIndex;
            this.tokenParserByteBuffer[n] = (byte)(this.tokenParserByteBuffer[n] + intValue);
            theNextByte = randomAcccessRead.read();
        }
        byte[] finalResult = new byte[bufferIndex + 1];
        System.arraycopy(this.tokenParserByteBuffer, 0, finalResult, 0, bufferIndex + 1);
        return finalResult;
    }

    private void readUntilEndOfLine(RandomAccessRead randomAcccessRead, StringBuilder buf) throws IOException {
        int nextByte = randomAcccessRead.read();
        while (nextByte != -1 && nextByte != 13 && nextByte != 10) {
            buf.append((char)nextByte);
            nextByte = randomAcccessRead.read();
        }
    }

    private static boolean isWhitespaceOrEOF(int aByte) {
        switch (aByte) {
            case -1: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDelimiter(int aByte) {
        switch (aByte) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private static boolean increment(byte[] data, int position, boolean useStrictMode) {
        if (position > 0 && (data[position] & 0xFF) == 255) {
            if (useStrictMode) {
                return false;
            }
            data[position] = 0;
            CMapParser.increment(data, position - 1, useStrictMode);
        } else {
            data[position] = (byte)(data[position] + 1);
        }
        return true;
    }

    private static String createStringFromBytes(byte[] bytes) {
        if (bytes.length <= 2) {
            return CMapStrings.getMapping(bytes);
        }
        return new String(bytes, StandardCharsets.UTF_16BE);
    }

    private static final class Operator {
        private final String op;

        private Operator(String theOp) {
            this.op = theOp;
        }
    }

    private static final class LiteralName {
        private final String name;

        private LiteralName(String theName) {
            this.name = theName;
        }
    }
}

