/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.Map;
import org.apache.fop.utils.text.AdvancedMessageFormat;

public class HexFieldPart
implements AdvancedMessageFormat.Part {
    private String fieldName;

    public HexFieldPart(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isGenerated(Map params) {
        Object obj = params.get(this.fieldName);
        return obj != null;
    }

    public void write(StringBuffer sb, Map params) {
        if (!params.containsKey(this.fieldName)) {
            throw new IllegalArgumentException("Message pattern contains unsupported field name: " + this.fieldName);
        }
        Object obj = params.get(this.fieldName);
        if (obj instanceof Character) {
            sb.append(Integer.toHexString(((Character)obj).charValue()));
        } else if (obj instanceof Number) {
            sb.append(Integer.toHexString(((Number)obj).intValue()));
        } else {
            throw new IllegalArgumentException("Incompatible value for hex field part: " + obj.getClass().getName());
        }
    }

    public String toString() {
        return "{" + this.fieldName + ",hex}";
    }

    public static class Factory
    implements AdvancedMessageFormat.PartFactory {
        @Override
        public AdvancedMessageFormat.Part newPart(String fieldName, String values2) {
            return new HexFieldPart(fieldName);
        }

        @Override
        public String getFormat() {
            return "hex";
        }
    }
}

